/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.crate;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.resource.adapter.CountFunctionAdapter;
import dev.toma.gunsrpg.resource.adapter.LootConfigurationAdapter;
import dev.toma.gunsrpg.resource.adapter.LootConfigurationCategoryAdapter;
import dev.toma.gunsrpg.resource.adapter.LootEntryAdapter;
import dev.toma.gunsrpg.resource.adapter.SlotConfigurationAdapter;
import dev.toma.gunsrpg.resource.crate.ICountFunction;
import dev.toma.gunsrpg.resource.crate.ILootContentProvider;
import dev.toma.gunsrpg.resource.crate.LootConfig;
import dev.toma.gunsrpg.resource.crate.LootConfigurationCategory;
import dev.toma.gunsrpg.resource.crate.LootEntry;
import dev.toma.gunsrpg.resource.crate.SlotConfiguration;
import dev.toma.gunsrpg.resource.util.functions.RangedFunction;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class LootManager
extends JsonReloadListener {
    public static final Marker MARKER = MarkerManager.getMarker((String)"LootManager");
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(LootConfig.class, (Object)new LootConfigurationAdapter()).registerTypeAdapter(LootConfigurationCategory.class, (Object)new LootConfigurationCategoryAdapter()).registerTypeAdapter(LootEntry.class, (Object)new LootEntryAdapter()).registerTypeAdapter(SlotConfiguration.class, (Object)new SlotConfigurationAdapter()).registerTypeHierarchyAdapter(ICountFunction.class, (Object)new CountFunctionAdapter(new RangedFunction(RangedFunction.BETWEEN_INCLUSIVE, 1, 64))).create();
    private final Map<ResourceLocation, LootConfig> configurationMap = new HashMap<ResourceLocation, LootConfig>();

    public LootManager() {
        super(GSON, "crate");
    }

    public ILootContentProvider getGeneratedContent(ResourceLocation configurationPath) {
        LootConfig config = this.configurationMap.get(configurationPath);
        if (config == null) {
            LootConfig emptyCfg = LootConfig.EMPTY;
            this.configurationMap.put(configurationPath, emptyCfg);
            GunsRPG.log.error(MARKER, "Unknown loot configuration {}, will use empty configuration instead", (Object)configurationPath);
            return emptyCfg.getRandomContent();
        }
        return config.getRandomContent();
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, IResourceManager manager, IProfiler profiler) {
        GunsRPG.log.info(MARKER, "Loading loot configurations");
        this.configurationMap.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation key = entry.getKey();
            try {
                LootConfig config = this.loadConfiguration(entry.getValue());
                this.configurationMap.put(key, config);
            }
            catch (JsonParseException e) {
                GunsRPG.log.error(MARKER, "Error loading loot configuration for {}, {}", (Object)key, (Object)e.toString());
            }
        }
        GunsRPG.log.info(MARKER, "Loot configurations have been loaded");
    }

    private LootConfig loadConfiguration(JsonElement element) throws JsonParseException {
        return (LootConfig)GSON.fromJson(element, LootConfig.class);
    }
}

